local t = Def.ActorFrame{};
local StatsP2 = GAMESTATE:IsPlayerEnabled(PLAYER_2) and IsStatsVisible(PLAYER_2) and GAMESTATE:GetNumPlayersEnabled() == 1 and not GAMESTATE:IsDemonstration()
local function IsW5Disabled() if PREFSMAN:GetPreference("TimingWindowSecondsW5") == 0 then return true else return false end end
local function TapNoteScore(pn,tns) return STATSMAN:GetCurStageStats():GetPlayerStageStats(pn):GetTapNoteScores(tns) end
local function TapPercentNoteScore(pn,tns) return STATSMAN:GetCurStageStats():GetPlayerStageStats(pn):GetPercentageOfTaps(tns) end
local function DetermineQuadWidth(pn,tns) local MaxWidth = 292 local CurrentWidth = TapPercentNoteScore(pn,tns) return CurrentWidth * MaxWidth end

local TabTitle
local JL1, JL2, JL3, JL4, JL5, JL6 -- Judgment Labels
local JR1, JR2, JR3, JR4, JR5, JR6 -- Judgment Results
local JRM1, JRM2, JRM3, JRM4, JRM5, JRM6 -- Judgment Results Mini
local JP1, JP2, JP3, JP4, JP5, JP6 -- Judgment Percent (%)
local QP1, QP2, QP3, QP4, QP5, QP6 -- Percent Quads
local QPB1, QPB2, QPB3, QPB4, QPB5, QPB6 -- Percent Background Quads

local function JudgmentTitleCallback(event)
	if event.type == "InputEventType_Release" then return false end
	if IsPlayerEnabled(PLAYER_2) then
		if event.DeviceInput.button == "DeviceButton_1" then show(TabTitle) end
		if event.DeviceInput.button == "DeviceButton_2" then hide(TabTitle) end
		if event.DeviceInput.button == "DeviceButton_3" then hide(TabTitle) end
		if event.DeviceInput.button == "DeviceButton_4" then hide(TabTitle) end
		if event.DeviceInput.button == "DeviceButton_5" then hide(TabTitle) end
		if event.DeviceInput.button == "DeviceButton_6" then hide(TabTitle) end
	end
end

-- Title
t[#t+1] = Def.ActorFrame{
	BeginCommand=cmd(visible,StatsP2);
	CommonNormal()..{
		Name="Judgment Title P2";
		InitCommand=cmd(xy,Left()+173,Top()+54;zoom,0.5;maxwidth,568;halign,0;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),3));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("CURRENT JUDGMENTS / GRAPH DISPLAY"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentTitleCallback) TabTitle=self self:visible(true) end;
	};
};

local function JudgmentLabelCallback(event)
	if event.type == "InputEventType_Release" then return false end
	if IsPlayerEnabled(PLAYER_2) then
		if event.DeviceInput.button == "DeviceButton_1" then show(JL1) show(JL2) show(JL3) show(JL4) show(JL6) end
		if event.DeviceInput.button == "DeviceButton_2" then hide(JL1) hide(JL2) hide(JL3) hide(JL4) hide(JL6) end
		if event.DeviceInput.button == "DeviceButton_3" then hide(JL1) hide(JL2) hide(JL3) hide(JL4) hide(JL6) end
		if event.DeviceInput.button == "DeviceButton_4" then hide(JL1) hide(JL2) hide(JL3) hide(JL4) hide(JL6) end
		if event.DeviceInput.button == "DeviceButton_5" then hide(JL1) hide(JL2) hide(JL3) hide(JL4) hide(JL6) end
		if event.DeviceInput.button == "DeviceButton_6" then hide(JL1) hide(JL2) hide(JL3) hide(JL4) hide(JL6) end
		if not IsW5Disabled() then
			if event.DeviceInput.button == "DeviceButton_1" then show(JL5) end
			if event.DeviceInput.button == "DeviceButton_2" then hide(JL5) end
			if event.DeviceInput.button == "DeviceButton_3" then hide(JL5) end
			if event.DeviceInput.button == "DeviceButton_4" then hide(JL5) end
			if event.DeviceInput.button == "DeviceButton_5" then hide(JL5) end
			if event.DeviceInput.button == "DeviceButton_6" then hide(JL5) end
		end
	end
end

t[#t+1] = Def.ActorFrame{
	BeginCommand=cmd(visible,StatsP2);
	Miso()..{
		Name="Perfect+ Label P2";
		InitCommand=cmd(xy,CenterX()-116,Top()+128;align,0,0;zoom,0.9;diffuse,color(jColors[1]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("PERFECT"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentLabelCallback) JL1=self self:visible(true) end;
	};
	Miso()..{
		Name="Perfect Label P2";
		InitCommand=cmd(xy,CenterX()-116,Top()+128+26;align,0,0;zoom,0.9;diffuse,color(jColors[2]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("PERFECT"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentLabelCallback) JL2=self self:visible(true) end;
	};
	Miso()..{
		Name="Great Label P2";
		InitCommand=cmd(xy,CenterX()-116,Top()+128+26*2;align,0,0;zoom,0.9;diffuse,color(jColors[3]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("GREAT"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentLabelCallback) JL3=self self:visible(true) end;
	};
	Miso()..{
		Name="Good Label P2";
		InitCommand=cmd(xy,CenterX()-116,Top()+128+26*3;align,0,0;zoom,0.9;diffuse,color(jColors[4]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("GOOD"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentLabelCallback) JL4=self self:visible(true) end;
	};
	Miso()..{
		Name="Bad Label P2";
		InitCommand=cmd(xy,CenterX()-116,Top()+128+26*4;align,0,0;zoom,0.9;diffuse,color(jColors[5]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then if IsW5Disabled() then self:settext("") else self:settext("BAD"):playcommand("Callback") end end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentLabelCallback) JL5=self self:visible(true) end;
	};
	Miso()..{
		Name="Miss Label P2";
		InitCommand=cmd(xy,CenterX()-116,Top()+128+26*(IsW5Disabled() and 4 or 5);align,0,0;zoom,0.9;diffuse,color(jColors[6]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("MISS"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentLabelCallback) JL6=self self:visible(true) end;
	};
};

local function JudgmentResultCallback(event)
	if event.type == "InputEventType_Release" then return false end
	if IsPlayerEnabled(PLAYER_2) then
		if event.DeviceInput.button == "DeviceButton_1" then show(JR1) show(JR2) show(JR3) show(JR4) show(JR6) end
		if event.DeviceInput.button == "DeviceButton_2" then hide(JR1) hide(JR2) hide(JR3) hide(JR4) hide(JR6) end
		if event.DeviceInput.button == "DeviceButton_3" then hide(JR1) hide(JR2) hide(JR3) hide(JR4) hide(JR6) end
		if event.DeviceInput.button == "DeviceButton_4" then hide(JR1) hide(JR2) hide(JR3) hide(JR4) hide(JR6) end
		if event.DeviceInput.button == "DeviceButton_5" then hide(JR1) hide(JR2) hide(JR3) hide(JR4) hide(JR6) end
		if event.DeviceInput.button == "DeviceButton_6" then hide(JR1) hide(JR2) hide(JR3) hide(JR4) hide(JR6) end
		if not IsW5Disabled() then
			if event.DeviceInput.button == "DeviceButton_1" then show(JR5) end
			if event.DeviceInput.button == "DeviceButton_2" then hide(JR5) end
			if event.DeviceInput.button == "DeviceButton_3" then hide(JR5) end
			if event.DeviceInput.button == "DeviceButton_4" then hide(JR5) end
			if event.DeviceInput.button == "DeviceButton_5" then hide(JR5) end
			if event.DeviceInput.button == "DeviceButton_6" then hide(JR5) end
		end
	end
end

t[#t+1] = Def.ActorFrame{
	BeginCommand=cmd(visible,StatsP2);
	MisoBold()..{
		Name="Perfect+ Result P2";
		InitCommand=cmd(xy,CenterX()-32,Top()+129;align,0,0;zoom,0.9;diffuse,color(jColors[1]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("-----"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentResultCallback) JR1=self self:visible(true) end;
		JudgmentMessageCommand=function(self)
			self:settext(string.format("%04.0f", TapNoteScore(PLAYER_2,9))):AddAttribute(0, {Length = LeadingToFourZeros(PLAYER_2,9); Diffuse = ColorDarkTone(color(jColors[1]))})
		end;
	};
	MisoBold()..{
		Name="Perfect Result P2";
		InitCommand=cmd(xy,CenterX()-32,Top()+129+26;align,0,0;zoom,0.9;diffuse,color(jColors[2]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("-----"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentResultCallback) JR2=self self:visible(true) end;
		JudgmentMessageCommand=function(self)
			self:settext(string.format("%04.0f", TapNoteScore(PLAYER_2,8))):AddAttribute(0, {Length = LeadingToFourZeros(PLAYER_2,8); Diffuse = ColorDarkTone(color(jColors[2]))})
		end;
	};
	MisoBold()..{
		Name="Great Result P2";
		InitCommand=cmd(xy,CenterX()-32,Top()+129+26*2;align,0,0;zoom,0.9;diffuse,color(jColors[3]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("-----"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentResultCallback) JR3=self self:visible(true) end;
		JudgmentMessageCommand=function(self)
			self:settext(string.format("%04.0f", TapNoteScore(PLAYER_2,7))):AddAttribute(0, {Length = LeadingToFourZeros(PLAYER_2,7); Diffuse = ColorDarkTone(color(jColors[3]))})
		end;
	};
	MisoBold()..{
		Name="Good Result P2";
		InitCommand=cmd(xy,CenterX()-32,Top()+129+26*3;align,0,0;zoom,0.9;diffuse,color(jColors[4]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("-----"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentResultCallback) JR4=self self:visible(true) end;
		JudgmentMessageCommand=function(self)
			self:settext(string.format("%04.0f", TapNoteScore(PLAYER_2,6))):AddAttribute(0, {Length = LeadingToFourZeros(PLAYER_2,6); Diffuse = ColorDarkTone(color(jColors[4]))})
		end;
	};
	MisoBold()..{
		Name="Bad Result P2";
		InitCommand=cmd(xy,CenterX()-32,Top()+129+26*4;align,0,0;zoom,0.9;diffuse,color(jColors[5]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then if IsW5Disabled() then self:settext("") else self:settext("-----"):playcommand("Callback") end end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentResultCallback) JR5=self self:visible(true) end;
		JudgmentMessageCommand=function(self)
			if IsW5Disabled() then self:settext("") else self:settext(string.format("%04.0f", TapNoteScore(PLAYER_2,5))):AddAttribute(0, {Length = LeadingToFourZeros(PLAYER_2,5); Diffuse = ColorDarkTone(color(jColors[5]))}) end
		end;
	};
	MisoBold()..{
		Name="Miss Result P2";
		InitCommand=cmd(xy,CenterX()-32,Top()+129+26*(IsW5Disabled() and 4 or 5);align,0,0;zoom,0.9;diffuse,color(jColors[6]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("-----"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentResultCallback) JR6=self self:visible(true) end;
		JudgmentMessageCommand=function(self)
			self:settext(string.format("%04.0f", TapNoteScore(PLAYER_2,4))):AddAttribute(0, {Length = LeadingToFourZeros(PLAYER_2,4); Diffuse = ColorDarkTone(color(jColors[6]))})
		end;
	};
};

local function QuadsCallback(event)
	if event.type == "InputEventType_Release" then return false end
	if IsPlayerEnabled(PLAYER_2) then
		if event.DeviceInput.button == "DeviceButton_1" then show(QP1) show(QPB1) show(QP2) show(QPB2) show(QP3) show(QPB3) show(QP4) show(QPB4) show(QP6) show(QPB6) end
		if event.DeviceInput.button == "DeviceButton_2" then hide(QP1) hide(QPB1) hide(QP2) hide(QPB2) hide(QP3) hide(QPB3) hide(QP4) hide(QPB4) hide(QP6) hide(QPB6) end
		if event.DeviceInput.button == "DeviceButton_3" then hide(QP1) hide(QPB1) hide(QP2) hide(QPB2) hide(QP3) hide(QPB3) hide(QP4) hide(QPB4) hide(QP6) hide(QPB6) end
		if event.DeviceInput.button == "DeviceButton_4" then hide(QP1) hide(QPB1) hide(QP2) hide(QPB2) hide(QP3) hide(QPB3) hide(QP4) hide(QPB4) hide(QP6) hide(QPB6) end
		if event.DeviceInput.button == "DeviceButton_5" then hide(QP1) hide(QPB1) hide(QP2) hide(QPB2) hide(QP3) hide(QPB3) hide(QP4) hide(QPB4) hide(QP6) hide(QPB6) end
		if event.DeviceInput.button == "DeviceButton_6" then hide(QP1) hide(QPB1) hide(QP2) hide(QPB2) hide(QP3) hide(QPB3) hide(QP4) hide(QPB4) hide(QP6) hide(QPB6) end
		if not IsW5Disabled() then
			if event.DeviceInput.button == "DeviceButton_1" then show(QP5) show(QPB5) end
			if event.DeviceInput.button == "DeviceButton_2" then hide(QP5) hide(QPB5) end
			if event.DeviceInput.button == "DeviceButton_3" then hide(QP5) hide(QPB5) end
			if event.DeviceInput.button == "DeviceButton_4" then hide(QP5) hide(QPB5) end
			if event.DeviceInput.button == "DeviceButton_5" then hide(QP5) hide(QPB5) end
			if event.DeviceInput.button == "DeviceButton_6" then hide(QP5) hide(QPB5) end
		end
	end
end

t[#t+1] = Def.ActorFrame{
	BeginCommand=cmd(visible,StatsP2);
	Def.Quad{ Name="Perfect+ Quad P2";
		InitCommand=cmd(x,Left()+8;y,Top()+132;setsize,0,0;align,0,0;diffuse,color(jColors[1]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(QuadsCallback) QP1=self self:visible(true) end;
		JudgmentMessageCommand=function(self) self:setsize(DetermineQuadWidth(PLAYER_2,9),20) end;
	};
	Def.Quad{ Name="Perfect+ Quad Background P2";
		InitCommand=cmd(x,Left()+8;y,Top()+132;setsize,0,0;align,0,0;diffuse,color(jColors[1]);diffusealpha,0.5);
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(QuadsCallback) QPB1=self self:visible(true):setsize(292,20) end;
	};
	Def.Quad{ Name="Perfect Quad P2";
		InitCommand=cmd(x,Left()+8;y,Top()+132+26;setsize,0,0;align,0,0;diffuse,color(jColors[2]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(QuadsCallback) QP2=self self:visible(true) end;
		JudgmentMessageCommand=function(self) self:setsize(DetermineQuadWidth(PLAYER_2,8),20) end;
	};
	Def.Quad{ Name="Perfect Quad Background P2";
		InitCommand=cmd(x,Left()+8;y,Top()+132+26;setsize,0,0;align,0,0;diffuse,color(jColors[2]);diffusealpha,0.5);
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(QuadsCallback) QPB2=self self:visible(true):setsize(292,20) end;
	};
	Def.Quad{ Name="Great Quad P2";
		InitCommand=cmd(x,Left()+8;y,Top()+132+26*2;setsize,0,0;align,0,0;diffuse,color(jColors[3]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(QuadsCallback) QP3=self self:visible(true) end;
		JudgmentMessageCommand=function(self) self:setsize(DetermineQuadWidth(PLAYER_2,7),20) end;
	};
	Def.Quad{ Name="Great Quad Background P2";
		InitCommand=cmd(x,Left()+8;y,Top()+132+26*2;setsize,0,0;align,0,0;diffuse,color(jColors[3]);diffusealpha,0.5);
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(QuadsCallback) QPB3=self self:visible(true):setsize(292,20) end;
	};
	Def.Quad{ Name="Good Quad P2";
		InitCommand=cmd(x,Left()+8;y,Top()+132+26*3;setsize,0,0;align,0,0;diffuse,color(jColors[4]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(QuadsCallback) QP4=self self:visible(true) end;
		JudgmentMessageCommand=function(self) self:setsize(DetermineQuadWidth(PLAYER_2,6),20) end;
	};
	Def.Quad{ Name="Good Quad Background P2";
		InitCommand=cmd(x,Left()+8;y,Top()+132+26*3;setsize,0,0;align,0,0;diffuse,color(jColors[4]);diffusealpha,0.5);
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(QuadsCallback) QPB4=self self:visible(true):setsize(292,20) end;
	};
	Def.Quad{ Name="Bad Quad P2";
		InitCommand=cmd(x,Left()+8;y,Top()+132+26*4;setsize,0,0;align,0,0;diffuse,color(jColors[5]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then if IsW5Disabled() then self:setsize(0,0) else self:playcommand("Callback") end end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(QuadsCallback) QP5=self self:visible(true) end;
		JudgmentMessageCommand=function(self) if IsW5Disabled() then self:setsize(0,0) else self:setsize(DetermineQuadWidth(PLAYER_2,5),20) end end;
	};
	Def.Quad{ Name="Bad Quad Background P2";
		InitCommand=cmd(x,Left()+8;y,Top()+132+26*4;setsize,0,0;align,0,0;diffuse,color(jColors[5]);diffusealpha,0.5);
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then if IsW5Disabled() then self:setsize(0,0) else self:playcommand("Callback") end end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(QuadsCallback) QPB5=self self:visible(true):setsize(292,20) end;
	};
	Def.Quad{ Name="Miss Quad P2";
		InitCommand=cmd(x,Left()+8;y,Top()+132+26*(IsW5Disabled() and 4 or 5);setsize,0,0;align,0,0;diffuse,color(jColors[6]));
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(QuadsCallback) QP6=self self:visible(true) end;
		JudgmentMessageCommand=function(self) self:setsize(DetermineQuadWidth(PLAYER_2,4),20) end;
	};
	Def.Quad{ Name="Miss Quad Background P2";
		InitCommand=cmd(x,Left()+8;y,Top()+132+26*(IsW5Disabled() and 4 or 5);setsize,0,0;align,0,0;diffuse,color(jColors[6]);diffusealpha,0.5);
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(QuadsCallback) QPB6=self self:visible(true):setsize(292,20) end;
	};
};

local function JudgmentPercentCallback(event)
	if event.type == "InputEventType_Release" then return false end
	if IsPlayerEnabled(PLAYER_2) then
		if event.DeviceInput.button == "DeviceButton_1" then show(JP1) show(JP2) show(JP3) show(JP4) show(JP6) end
		if event.DeviceInput.button == "DeviceButton_2" then hide(JP1) hide(JP2) hide(JP3) hide(JP4) hide(JP6) end
		if event.DeviceInput.button == "DeviceButton_3" then hide(JP1) hide(JP2) hide(JP3) hide(JP4) hide(JP6) end
		if event.DeviceInput.button == "DeviceButton_4" then hide(JP1) hide(JP2) hide(JP3) hide(JP4) hide(JP6) end
		if event.DeviceInput.button == "DeviceButton_5" then hide(JP1) hide(JP2) hide(JP3) hide(JP4) hide(JP6) end
		if event.DeviceInput.button == "DeviceButton_6" then hide(JP1) hide(JP2) hide(JP3) hide(JP4) hide(JP6) end
		if not IsW5Disabled() then
			if event.DeviceInput.button == "DeviceButton_1" then show(JP5) end
			if event.DeviceInput.button == "DeviceButton_2" then hide(JP5) end
			if event.DeviceInput.button == "DeviceButton_3" then hide(JP5) end
			if event.DeviceInput.button == "DeviceButton_4" then hide(JP5) end
			if event.DeviceInput.button == "DeviceButton_5" then hide(JP5) end
			if event.DeviceInput.button == "DeviceButton_6" then hide(JP5) end
		end
	end
end

t[#t+1] = Def.ActorFrame{
	BeginCommand=cmd(visible,StatsP2);
	Miso()..{
		Name="Perfect+ Percent P2";
		InitCommand=cmd(xy,CenterX()-130,Top()+133;align,1,0;zoom,0.6;diffuse,Black());
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0.00%"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentPercentCallback) JP1=self self:visible(true) end;
		JudgmentMessageCommand=function(self) self:settext(FormatPercentScore(TapPercentNoteScore(PLAYER_2,9))) if self:GetText() == "-1.#J%" then self:settext("0.00%") end end;
	};
	Miso()..{
		Name="Perfect Percent P2";
		InitCommand=cmd(xy,CenterX()-130,Top()+133+26;align,1,0;zoom,0.6;diffuse,Black());
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0.00%"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentPercentCallback) JP2=self self:visible(true) end;
		JudgmentMessageCommand=function(self) self:settext(FormatPercentScore(TapPercentNoteScore(PLAYER_2,8))) if self:GetText() == "-1.#J%" then self:settext("0.00%") end end;
	};
	Miso()..{
		Name="Great Percent P2";
		InitCommand=cmd(xy,CenterX()-130,Top()+133+26*2;align,1,0;zoom,0.6;diffuse,Black());
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0.00%"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentPercentCallback) JP3=self self:visible(true) end;
		JudgmentMessageCommand=function(self) self:settext(FormatPercentScore(TapPercentNoteScore(PLAYER_2,7))) if self:GetText() == "-1.#J%" then self:settext("0.00%") end end;
	};
	Miso()..{
		Name="Good Percent P2";
		InitCommand=cmd(xy,CenterX()-130,Top()+133+26*3;align,1,0;zoom,0.6;diffuse,Black());
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0.00%"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentPercentCallback) JP4=self self:visible(true) end;
		JudgmentMessageCommand=function(self) self:settext(FormatPercentScore(TapPercentNoteScore(PLAYER_2,6))) if self:GetText() == "-1.#J%" then self:settext("0.00%") end end;
	};
	Miso()..{
		Name="Bad Percent P2";
		InitCommand=cmd(xy,CenterX()-130,Top()+133+26*4;align,1,0;zoom,0.6;diffuse,Black());
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then if IsW5Disabled() then self:settext("") else self:settext("0.00%"):playcommand("Callback") end end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentPercentCallback) JP5=self self:visible(true) end;
		JudgmentMessageCommand=function(self) if IsW5Disabled() then self:settext("") else self:settext(FormatPercentScore(TapPercentNoteScore(PLAYER_2,5))) if self:GetText() == "-1.#J%" then self:settext("0.00%") end end end;
	};
	Miso()..{
		Name="Miss Percent P2";
		InitCommand=cmd(xy,CenterX()-130,Top()+133+26*(IsW5Disabled() and 4 or 5);align,1,0;zoom,0.6;diffuse,Black());
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0.00%"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentPercentCallback) JP6=self self:visible(true) end;
		JudgmentMessageCommand=function(self) self:settext(FormatPercentScore(TapPercentNoteScore(PLAYER_2,4))) if self:GetText() == "-1.#J%" then self:settext("0.00%") end end;
	};
};

local function JudgmentResultMiniCallback(event)
	if event.type == "InputEventType_Release" then return false end
	if IsPlayerEnabled(PLAYER_2) then
		if event.DeviceInput.button == "DeviceButton_1" then show(JRM1) show(JRM2) show(JRM3) show(JRM4) show(JRM6) end
		if event.DeviceInput.button == "DeviceButton_2" then hide(JRM1) hide(JRM2) hide(JRM3) hide(JRM4) hide(JRM6) end
		if event.DeviceInput.button == "DeviceButton_3" then hide(JRM1) hide(JRM2) hide(JRM3) hide(JRM4) hide(JRM6) end
		if event.DeviceInput.button == "DeviceButton_4" then hide(JRM1) hide(JRM2) hide(JRM3) hide(JRM4) hide(JRM6) end
		if event.DeviceInput.button == "DeviceButton_5" then hide(JRM1) hide(JRM2) hide(JRM3) hide(JRM4) hide(JRM6) end
		if event.DeviceInput.button == "DeviceButton_6" then hide(JRM1) hide(JRM2) hide(JRM3) hide(JRM4) hide(JRM6) end
		if not IsW5Disabled() then
			if event.DeviceInput.button == "DeviceButton_1" then show(JRM5) end
			if event.DeviceInput.button == "DeviceButton_2" then hide(JRM5) end
			if event.DeviceInput.button == "DeviceButton_3" then hide(JRM5) end
			if event.DeviceInput.button == "DeviceButton_4" then hide(JRM5) end
			if event.DeviceInput.button == "DeviceButton_5" then hide(JRM5) end
			if event.DeviceInput.button == "DeviceButton_6" then hide(JRM5) end
		end
	end
end

t[#t+1] = Def.ActorFrame{
	BeginCommand=cmd(visible,StatsP2);
	MisoBold()..{
		Name="Perfect+ ResultMini P2";
		InitCommand=cmd(xy,Left()+12,Top()+133;align,0,0;zoom,0.65;diffuse,Black());
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentResultMiniCallback) JRM1=self self:visible(true) end;
		JudgmentMessageCommand=function(self) self:settext(string.format("%04.0f", TapNoteScore(PLAYER_2,9))) end;
	};
	MisoBold()..{
		Name="Perfect Result Mini P2";
		InitCommand=cmd(xy,Left()+12,Top()+133+26;align,0,0;zoom,0.65;diffuse,Black());
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentResultMiniCallback) JRM2=self self:visible(true) end;
		JudgmentMessageCommand=function(self) self:settext(string.format("%04.0f", TapNoteScore(PLAYER_2,8))) end;
	};
	MisoBold()..{
		Name="Great Result Mini P2";
		InitCommand=cmd(xy,Left()+12,Top()+133+26*2;align,0,0;zoom,0.65;diffuse,Black());
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentResultMiniCallback) JRM3=self self:visible(true) end;
		JudgmentMessageCommand=function(self) self:settext(string.format("%04.0f", TapNoteScore(PLAYER_2,7))) end;
	};
	MisoBold()..{
		Name="Good Result Mini P2";
		InitCommand=cmd(xy,Left()+12,Top()+133+26*3;align,0,0;zoom,0.65;diffuse,Black());
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentResultMiniCallback) JRM4=self self:visible(true) end;
		JudgmentMessageCommand=function(self) self:settext(string.format("%04.0f", TapNoteScore(PLAYER_2,6))) end;
	};
	MisoBold()..{
		Name="Bad Result Mini P2";
		InitCommand=cmd(xy,Left()+12,Top()+133+26*4;align,0,0;zoom,0.65;diffuse,Black());
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then if IsW5Disabled() then self:settext("") else self:settext("0000"):playcommand("Callback") end end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentResultMiniCallback) JRM5=self self:visible(true) end;
		JudgmentMessageCommand=function(self) if IsW5Disabled() then self:settext("") else self:settext(string.format("%04.0f", TapNoteScore(PLAYER_2,5))) end end;
	};
	MisoBold()..{
		Name="Miss Result Mini P2";
		InitCommand=cmd(xy,Left()+12,Top()+133+26*(IsW5Disabled() and 4 or 5);align,0,0;zoom,0.65;diffuse,Black());
		OnCommand=function(self) if IsPlayerEnabled(PLAYER_2) then self:settext("0000"):playcommand("Callback") end end;
		CallbackCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(JudgmentResultMiniCallback) JRM6=self self:visible(true) end;
		JudgmentMessageCommand=function(self) self:settext(string.format("%04.0f", TapNoteScore(PLAYER_2,4))) end;
	};
};

return t